// 2003/03/18 LogPage.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using NTF.HXD.DOC;
using NTF.GUI;
using NTF.DOC;

namespace NTF.HXD.GUI.TabPage
{
	/// <summary>
	/// Or[AɎgpRg[łB
	/// </summary>
	public class LogPage : System.Windows.Forms.UserControl , IConfigTabPage
	{

		#region Rg[

		private System.Windows.Forms.ToolBar toolBar;
		private System.Windows.Forms.ToolBarButton tbReload;
		private System.Windows.Forms.ToolBarButton tbSave;
		private System.Windows.Forms.ImageList imageList;
		private System.ComponentModel.IContainer components;

		#endregion
		private System.Windows.Forms.RichTextBox logBox;


		Appli appli;

		public LogPage(Appli appli)
		{
			InitializeComponent();

			this.appli = appli;

			this.logBox.ContextMenu = new RichTextBoxContextMenu( this.logBox );

			LoadConfig();

			appli.FileWatcher.AddWatchFile( appli.ServerConfig.PathsConfig.Log );
			appli.FileWatcher.Changed += new FileWatcher.ChangedEventHandler( this.OnChanged );
			appli.HXDBootManager.Stoped += new EventHandler(HXD_Exited);
			this.Dock = DockStyle.Fill;
		}


		/// <summary>
		/// ݒǂݍŔf܂B
		/// </summary>
		public void LoadConfig()
		{
			LinuxFile lFile = new LinuxFile();
			System.Text.StringBuilder b = lFile.Load( appli.ServerConfig.PathsConfig.Log );

			if( b == null )
			{
				return;
			}

			this.logBox.Text = b.ToString();
			this.logBox.Select( this.logBox.Text.Length , 0 );
		}


		/// <summary>
		/// ݒvpeBɊi[܂B
		/// </summary>
		public void SaveConfig()
		{
			LinuxFile lFile = new LinuxFile();

			try
			{
				lFile.Write( appli.ServerConfig.PathsConfig.Log ,
					this.logBox.Text );
			}
			catch
			{
//				MessageBox.Show ( "O̕ۑɎs܂B" , "G[",
//					MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
		}


		/// <summary>
		/// ݒ肪ύXAݒ𔽉fɂ͍ċNKvȂƂtrueԂB
		/// </summary>
		public bool Changed
		{
			get{return false;}
			set{}
		}


		#region Dispose
		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion


		#region Component Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(LogPage));
			this.toolBar = new System.Windows.Forms.ToolBar();
			this.tbReload = new System.Windows.Forms.ToolBarButton();
			this.tbSave = new System.Windows.Forms.ToolBarButton();
			this.imageList = new System.Windows.Forms.ImageList(this.components);
			this.logBox = new System.Windows.Forms.RichTextBox();
			this.SuspendLayout();
			// 
			// toolBar
			// 
			this.toolBar.Appearance = System.Windows.Forms.ToolBarAppearance.Flat;
			this.toolBar.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
																																							 this.tbReload,
																																							 this.tbSave});
			this.toolBar.DropDownArrows = true;
			this.toolBar.ImageList = this.imageList;
			this.toolBar.Name = "toolBar";
			this.toolBar.ShowToolTips = true;
			this.toolBar.Size = new System.Drawing.Size(584, 25);
			this.toolBar.TabIndex = 2;
			this.toolBar.TextAlign = System.Windows.Forms.ToolBarTextAlign.Right;
			this.toolBar.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.toolBar_ButtonClick);
			// 
			// tbReload
			// 
			this.tbReload.ImageIndex = 0;
			this.tbReload.Text = "ēǂݍ";
			// 
			// tbSave
			// 
			this.tbSave.ImageIndex = 1;
			this.tbSave.Text = "I͈͂ۑ";
			// 
			// imageList
			// 
			this.imageList.ColorDepth = System.Windows.Forms.ColorDepth.Depth8Bit;
			this.imageList.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList.ImageStream")));
			this.imageList.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// logBox
			// 
			this.logBox.Dock = System.Windows.Forms.DockStyle.Fill;
			this.logBox.HideSelection = false;
			this.logBox.Location = new System.Drawing.Point(0, 25);
			this.logBox.MaxLength = 0;
			this.logBox.Name = "logBox";
			this.logBox.Size = new System.Drawing.Size(584, 233);
			this.logBox.TabIndex = 3;
			this.logBox.Text = "";
			this.logBox.WordWrap = false;
			// 
			// LogPage
			// 
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																																	this.logBox,
																																	this.toolBar});
			this.Name = "LogPage";
			this.Size = new System.Drawing.Size(584, 258);
			this.ResumeLayout(false);

		}
		#endregion


		private void toolBar_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			switch(toolBar.Buttons.IndexOf(e.Button))
			{
				case 0:
					this.LoadConfig();
					break;

				case 1:
					Support.SaveSelectedText(this.logBox);
					break;
			}
		}

		private void OnChanged()
		{
			if( this.appli.AppConfig.AutoReload )
			{
				this.logBox.Text = string.Empty;
				this.LoadConfig();
			}
		}

		private void HXD_Exited(object sender , EventArgs e)
		{
			try
			{
				if( appli.AppConfig.LogClear )
				{
					this.logBox.Text = string.Empty;
					System.IO.File.Delete( appli.ServerConfig.PathsConfig.Log );
				}
			}
			catch(System.Exception error)
			{
				System.Diagnostics.Debug.WriteLine(error);
			}
		}

	}
}
